#ifndef _BINARY_NODE
#define _BINARY_NODE

template<class Type>
class BinaryNode {
private:
	Type item;         // Data portion
	BinaryNode<Type>* leftPtr;		// Pointer to left child
	BinaryNode<Type>* rightPtr;		// Pointer to right child

public:
	// constructors
	BinaryNode(const Type&);
	BinaryNode(const Type&, BinaryNode<Type>*, BinaryNode<Type>*);

	// destructor
	~BinaryNode();

	// accessors
	void setItem(const Type&);
	void setLeftPtr(BinaryNode<Type>*);
	void setRightPtr(BinaryNode<Type>*);

	// mutators
	Type getItem() const;
	BinaryNode<Type>* getLeftPtr() const;
	BinaryNode<Type>* getRightPtr() const;

	bool isLeaf() const;
};


template<class Type>
BinaryNode<Type>::BinaryNode(const Type& anItem)
{
	item = anItem;
	leftPtr = nullptr;
	rightPtr = nullptr;
}

template<class Type>
BinaryNode<Type>::BinaryNode(const Type& anItem, BinaryNode<Type>* left, BinaryNode<Type>* right)
{
	item = anItem;
	leftPtr = left;
	rightPtr = right;
}

template<class Type>
BinaryNode<Type>::~BinaryNode()
{
	leftPtr = nullptr;
	rightPtr = nullptr;
}

template<class Type>
void BinaryNode<Type>::setItem(const Type& anItem)
{ 
	item = anItem; 
}

template<class Type>
void BinaryNode<Type>::setLeftPtr(BinaryNode<Type>* left)
{ 
	leftPtr = left; 
}

template<class Type>
void BinaryNode<Type>::setRightPtr(BinaryNode<Type>* right)
{
	rightPtr = right;
}

template<class Type>
Type BinaryNode<Type>::getItem() const
{
	return item;
}

template<class Type>
BinaryNode<Type>* BinaryNode<Type>::getLeftPtr() const
{
	return leftPtr;
}

template<class Type>
BinaryNode<Type>* BinaryNode<Type>::getRightPtr() const
{
	return rightPtr;
}

template<class Type>
bool BinaryNode<Type>::isLeaf() const
{
	if (rightPtr == nullptr && rightPtr == nullptr)
	{
		return true;
	}
	else{
		return false;
	}
}

#endif 